<?php

class WebControllerTestCase extends CWebTestCase
{
	protected $_users = array(
		'admin' => array('admin', 'admin'),
		'teacher' => array('piotrek', 'admin'),
		'student' => array('kontakt@pyramidlab.pl', 'admin', array(
			'student/main/login', 'UserStudentLoginForm[login]', 'UserStudentLoginForm[password]'
		))
	);

	protected function login($role, $forceLogOut = false)
	{
		$loginUrl = isset($this->_users[$role][2]) ? $this->_users[$role][2][0] : 'administration/main/login';
		$loginFieldName = isset($this->_users[$role][2]) ? $this->_users[$role][2][1] : 'UserAdministratorLoginForm[login]';
		$passFieldName = isset($this->_users[$role][2]) ? $this->_users[$role][2][2] : 'UserAdministratorLoginForm[password]';
		if ($forceLogOut)
			$this->logout();
		$this->open($loginUrl);
		$this->assertElementPresent('name=' . $loginFieldName);
		$this->assertElementPresent('name=' . $passFieldName);
		$this->type('name=' . $loginFieldName, $this->_users[$role][0]);
		$this->type('name=' . $passFieldName, $this->_users[$role][1]);
		$this->clickAndWait("//input[@value='Zaloguj']");
		$this->assertNotLocation(TEST_BASE_URL . $loginUrl);
		$this->assertTextPresent('Wyloguj');
	}

	protected function logout()
	{
		$this->open('administration/main/logout');
	}

	protected function setUp()
	{
		parent::setUp();
		$this->setBrowser('firefox');
		$this->setBrowserUrl(TEST_BASE_URL);
	}
}
